<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px; text-align: center;">
    <div class="card">
        <h1 style="color: green;">Pedido Realizado com Sucesso!</h1>
        <p style="font-size: 1.2rem;">Obrigado, <?= htmlspecialchars($order['customer_name']) ?>!</p>
        <p>Seu pedido <strong>#<?= $order['id'] ?></strong> já foi enviado para a cozinha do Bob Esponja.</p>
        
        <?php if (!empty($pixConfig)): ?>
            <div style="background: #f9f9f9; padding: 20px; border: 1px dashed #ccc; margin: 20px 0; border-radius: 8px;">
                <h3 style="margin-top: 0; color: #333;">Pagamento via Pix</h3>
                <p>Valor a pagar: <strong>R$ <?= number_format($order['total_amount'], 2, ',', '.') ?></strong></p>
                
                <?php if (!empty($pixConfig['pix_qr_image'])): ?>
                    <div style="margin: 15px 0;">
                        <?php 
                            $qrUrl = $pixConfig['pix_qr_image'];
                            if ($qrUrl && strpos($qrUrl, 'http') !== 0) {
                                $qrUrl = $baseUrl . '/' . ltrim($qrUrl, '/');
                            }
                        ?>
                        <img src="<?= $qrUrl ?>" alt="QR Code Pix" style="max-width: 200px; border: 1px solid #ddd; padding: 5px; border-radius: 6px;">
                    </div>
                <?php endif; ?>

                <?php if (!empty($pixConfig['pix_key_value']) && $pixConfig['pix_key_type'] !== 'qr_file'): ?>
                    <div style="margin-top: 15px;">
                        <p style="margin-bottom: 5px; font-size: 0.9rem; color: #666;">Chave Pix (<?= ucfirst($pixConfig['pix_key_type']) ?>):</p>
                        <div style="display: flex; justify-content: center; gap: 10px; align-items: center; flex-wrap: wrap;">
                            <input type="text" value="<?= htmlspecialchars($pixConfig['pix_key_value']) ?>" readonly id="pixKey" 
                                style="padding: 8px; border: 1px solid #ddd; border-radius: 4px; width: 250px; text-align: center; background: #fff;">
                            <button onclick="copyPix()" class="btn" style="padding: 8px 15px; font-size: 0.9rem;">Copiar</button>
                        </div>
                    </div>
                <?php endif; ?>
                
                <p style="margin-top: 15px; font-size: 0.85rem; color: #777;">Após o pagamento, envie o comprovante no WhatsApp.</p>
            </div>
            
            <script>
            function copyPix() {
                var copyText = document.getElementById("pixKey");
                copyText.select();
                copyText.setSelectionRange(0, 99999); 
                navigator.clipboard.writeText(copyText.value);
                alert("Chave Pix copiada!");
            }
            </script>
        <?php endif; ?>

        <a href="<?= $whatsappLink ?>" target="_blank" class="btn" style="background: #25D366; color: white;">
            📱 Acompanhar pelo WhatsApp
        </a>
        <br><br>
        <a href="/rastreio/<?= $order['id'] ?>" class="btn" style="background: #00A8E8; color: white;">
            🛵 Rastrear Pedido no Site
        </a>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
