<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <div class="card">
        <h2 style="color: var(--accent);">Seu Carrinho</h2>
        
        <?php if (empty($cart)): ?>
            <p>Seu carrinho está vazio como a cabeça do Patrick.</p>
            <a href="/" class="btn">Ir para o Cardápio</a>
        <?php else: ?>
            <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                <thead>
                    <tr style="border-bottom: 2px solid #eee;">
                        <th style="text-align: left; padding: 10px;">Item</th>
                        <th style="text-align: center; padding: 10px;">Qtd</th>
                        <th style="text-align: right; padding: 10px;">Total</th>
                        <th style="padding: 10px;"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($cart as $index => $item): ?>
                        <tr style="border-bottom: 1px solid #eee;">
                            <td style="padding: 10px;">
                                <strong><?= htmlspecialchars($item['name']) ?></strong>
                                <?php if (!empty($item['notes'])): ?>
                                    <br><small style="color: #666;">Obs: <?= htmlspecialchars($item['notes']) ?></small>
                                <?php endif; ?>
                            </td>
                            <td style="text-align: center; padding: 10px;"><?= $item['quantity'] ?></td>
                            <td style="text-align: right; padding: 10px;">R$ <?= number_format($item['total_price'], 2, ',', '.') ?></td>
                            <td style="text-align: right; padding: 10px;">
                                <a href="/carrinho/remove/<?= $index ?>" style="color: red; text-decoration: none;">&times;</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <div style="text-align: right; margin-bottom: 20px;">
                <h3>Total: R$ <?= number_format($total, 2, ',', '.') ?></h3>
            </div>

            <div style="text-align: right;">
                <a href="/" class="btn" style="background: #ccc; margin-right: 10px;">Continuar Comprando</a>
                <a href="/checkout" class="btn">Finalizar Pedido</a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
