<?php include __DIR__ . '/../../layout/header.php'; ?>
<div class="container" style="margin-top: 20px;">
    <h2><?= isset($user) ? 'Editar Usuário' : 'Novo Usuário' ?></h2>
    <div class="card" style="max-width: 600px; margin: 0 auto;">
        <form action="<?= isset($user) ? $baseUrl . '/admin/usuarios/' . $user['id'] . '/editar' : $baseUrl . '/admin/usuarios/novo' ?>" method="POST">
            <div style="margin-bottom: 15px;">
                <label>Nome Completo</label>
                <input type="text" name="name" value="<?= htmlspecialchars($user['name'] ?? '') ?>" required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            
            <div style="margin-bottom: 15px;">
                <label>Nome de Usuário (Login)</label>
                <input type="text" name="username" value="<?= htmlspecialchars($user['username'] ?? '') ?>" required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div style="margin-bottom: 15px;">
                <label>Senha <?= isset($user) ? '(Deixe em branco para manter a atual)' : '' ?></label>
                <input type="password" name="password" <?= isset($user) ? '' : 'required' ?> style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div style="margin-bottom: 15px;">
                <label>Tipo de Usuário</label>
                <select name="role" class="form-control" onchange="togglePermissions(this.value)" style="width: 100%; padding: 8px;">
                    <option value="employee" <?= ($user['role'] ?? '') == 'employee' ? 'selected' : '' ?>>Funcionário</option>
                    <option value="admin" <?= ($user['role'] ?? '') == 'admin' ? 'selected' : '' ?>>Administrador</option>
                </select>
            </div>

            <div id="permissions-box" style="margin-bottom: 15px; background: #f9f9f9; padding: 15px; border-radius: 4px; <?= ($user['role'] ?? '') == 'admin' ? 'display:none;' : '' ?>">
                <label style="display: block; margin-bottom: 10px; font-weight: bold;">Permissões de Acesso:</label>
                
                <div style="margin-bottom: 8px;">
                    <label>
                        <input type="checkbox" checked disabled> 
                        Cozinha (Acesso Obrigatório)
                    </label>
                </div>
                
                <div style="margin-bottom: 8px;">
                    <label>
                        <input type="checkbox" checked disabled> 
                        Ver Dashboard (Acesso Obrigatório)
                    </label>
                </div>

                <?php 
                    $perms = $user['permissions'] ?? [];
                ?>

                <div style="margin-bottom: 8px;">
                    <label>
                        <input type="checkbox" name="perm_stock" value="1" <?= in_array('stock', $perms) ? 'checked' : '' ?>> 
                        Gerenciar Estoque
                    </label>
                </div>

                <div style="margin-bottom: 8px;">
                    <label>
                        <input type="checkbox" name="perm_menu" value="1" <?= in_array('menu', $perms) ? 'checked' : '' ?>> 
                        Gerenciar Cardápio
                    </label>
                </div>

                <div style="margin-bottom: 8px;">
                    <label>
                        <input type="checkbox" name="perm_sales" value="1" <?= in_array('sales', $perms) ? 'checked' : '' ?>> 
                        Ver Vendas do Dia
                    </label>
                </div>
            </div>

            <button type="submit" class="btn" style="width: 100%; background: #4CAF50; color: white;">Salvar</button>
        </form>
    </div>
</div>

<script>
function togglePermissions(role) {
    const box = document.getElementById('permissions-box');
    if (role === 'admin') {
        box.style.display = 'none';
    } else {
        box.style.display = 'block';
    }
}
</script>

<?php include __DIR__ . '/../../layout/footer.php'; ?>