<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <h2>🎫 Tickets Diários (Pedidos de Hoje)</h2>
    
    <?php if (empty($orders)): ?>
        <div class="card">
            <p>Nenhum pedido realizado hoje.</p>
        </div>
    <?php else: ?>
        <div class="card">
            <table style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f0f0f0; border-bottom: 2px solid #ddd;">
                        <th style="padding: 10px; text-align: left;">ID</th>
                        <th style="padding: 10px; text-align: left;">Cliente</th>
                        <th style="padding: 10px; text-align: left;">Status</th>
                        <th style="padding: 10px; text-align: left;">Total</th>
                        <th style="padding: 10px; text-align: left;">Hora</th>
                        <th style="padding: 10px; text-align: left;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        $statusLabels = [
                            'pending' => 'Recebido',
                            'preparing' => 'Preparando',
                            'ready' => 'Pronto',
                            'delivery' => 'Saiu para Entrega',
                            'completed' => 'Entregue',
                        ];
                    ?>
                    <?php foreach ($orders as $order): ?>
                        <tr style="border-bottom: 1px solid #eee;">
                            <td style="padding: 10px;">#<?= $order['id'] ?></td>
                            <td style="padding: 10px;">
                                <strong><?= htmlspecialchars($order['customer_name'] ?? '') ?></strong><br>
                                <small><?= htmlspecialchars($order['customer_phone'] ?? '') ?></small>
                            </td>
                            <td style="padding: 10px;">
                                <span style="padding: 4px 8px; border-radius: 4px; background: <?= $order['status'] == 'completed' ? '#d4edda' : ($order['status'] == 'pending' ? '#fff3cd' : '#e2e3e5') ?>">
                                    <?= $statusLabels[$order['status']] ?? ucfirst($order['status']) ?>
                                </span>
                            </td>
                            <td style="padding: 10px;">R$ <?= number_format($order['total_amount'], 2, ',', '.') ?></td>
                            <td style="padding: 10px;"><?= date('H:i', strtotime($order['created_at'])) ?></td>
                            <td style="padding: 10px;">
                                <a href="/rastreio/<?= $order['id'] ?>" class="btn" style="padding: 5px 10px; font-size: 0.8rem;">Ver</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
