<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h2>Ficha Técnica: <?= htmlspecialchars($product['name']) ?></h2>
        <a href="/admin/cardapio" class="btn" style="background: #607D8B; color: white;">Voltar</a>
    </div>

    <div style="display: flex; gap: 20px; flex-wrap: wrap;">
        <!-- Lista Atual -->
        <div style="flex: 2; min-width: 300px;" class="card">
            <h3>Ingredientes Utilizados</h3>
            <table style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="background: #f0f0f0;">
                        <th style="padding: 10px; text-align: left;">Ingrediente</th>
                        <th style="padding: 10px; text-align: center;">Quantidade por Unidade</th>
                        <th style="padding: 10px; text-align: right;">Ação</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($linkedIngredients)): ?>
                        <tr><td colspan="3" style="padding: 20px; text-align: center;">Nenhum ingrediente vinculado.</td></tr>
                    <?php else: ?>
                        <?php foreach ($linkedIngredients as $item): ?>
                            <tr style="border-bottom: 1px solid #eee;">
                                <td style="padding: 10px;"><?= htmlspecialchars($item['name']) ?></td>
                                <td style="padding: 10px; text-align: center;">
                                    <?= floatval($item['required_quantity']) ?> <?= $item['unit'] ?>
                                </td>
                                <td style="padding: 10px; text-align: right;">
                                    <form action="/admin/cardapio/<?= $product['id'] ?>/ingredientes/<?= $item['id'] ?>/excluir" method="POST" onsubmit="return confirm('Remover ingrediente?');">
                                        <button type="submit" style="color: red; border: none; background: none; cursor: pointer;">🗑️ Remover</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Adicionar -->
        <div style="flex: 1; min-width: 300px;" class="card">
            <h3>Adicionar Ingrediente</h3>
            <form action="/admin/cardapio/<?= $product['id'] ?>/ingredientes" method="POST">
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 5px;">Ingrediente</label>
                    <select name="ingredient_id" required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                        <option value="">Selecione...</option>
                        <?php foreach ($allIngredients as $ing): ?>
                            <option value="<?= $ing['id'] ?>"><?= htmlspecialchars($ing['name']) ?> (<?= $ing['unit'] ?>)</option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 5px;">Quantidade Gasta</label>
                    <input type="text" name="quantity" required placeholder="Ex: 0.200" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                    <small style="color: #666;">Use ponto ou vírgula</small>
                </div>

                <button type="submit" class="btn" style="width: 100%; background: #4CAF50; color: white;">Adicionar / Atualizar</button>
            </form>
            
            <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">
            <p style="font-size: 14px; color: #666;">
                Isso define quanto será descontado do estoque automaticamente quando este produto for vendido.
            </p>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>