<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <div style="margin-bottom: 20px;">
        <a href="/admin/cardapio" class="btn" style="background: #ddd; color: #333;">&larr; Voltar para Cardápio</a>
    </div>

    <h2>🍔 Adicionais: <?= htmlspecialchars($product['name']) ?></h2>
    
    <div class="card" style="margin-top: 20px;">
        <div style="display: flex; flex-wrap: wrap; gap: 30px;">
            <!-- Lista de Adicionais -->
            <div style="flex: 2; min-width: 300px;">
                <h3>Adicionais Configurados</h3>
                
                <?php if (empty($options)): ?>
                    <p style="color: #777; font-style: italic;">Nenhum adicional cadastrado para este produto.</p>
                <?php else: ?>
                    <table style="width: 100%; border-collapse: collapse;">
                        <thead>
                            <tr style="background: #f0f0f0;">
                                <th style="padding: 10px; text-align: left;">Nome</th>
                                <th style="padding: 10px; text-align: right;">Preço Adicional</th>
                                <th style="padding: 10px; text-align: center;">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($options as $opt): ?>
                                <tr style="border-bottom: 1px solid #eee;">
                                    <td style="padding: 10px;"><?= htmlspecialchars($opt['name']) ?></td>
                                    <td style="padding: 10px; text-align: right;">
                                        <?= $opt['additional_price'] > 0 ? '+ R$ ' . number_format($opt['additional_price'], 2, ',', '.') : 'Grátis' ?>
                                    </td>
                                    <td style="padding: 10px; text-align: center;">
                                        <form action="/admin/cardapio/<?= $product['id'] ?>/adicionais/<?= $opt['id'] ?>/excluir" method="POST" onsubmit="return confirm('Excluir este adicional?');">
                                            <button type="submit" class="btn" style="padding: 5px 10px; font-size: 0.8rem; background: #f44336; color: white;">Excluir</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>

            <!-- Formulário de Novo Adicional -->
            <div style="flex: 1; min-width: 250px; background: #f9f9f9; padding: 20px; border-radius: 8px;">
                <h3 style="margin-top: 0;">Novo Adicional</h3>
                <form action="/admin/cardapio/<?= $product['id'] ?>/adicionais" method="POST">
                    <div style="margin-bottom: 15px;">
                        <label for="name" style="display: block; margin-bottom: 5px;">Nome do item</label>
                        <input type="text" id="name" name="name" placeholder="Ex: Bacon Extra" required
                            style="width: 100%; padding: 8px; border-radius: 6px; border: 1px solid #ddd;">
                    </div>

                    <div style="margin-bottom: 15px;">
                        <label for="price" style="display: block; margin-bottom: 5px;">Preço Adicional (R$)</label>
                        <input type="text" id="price" name="price" placeholder="0,00"
                            style="width: 100%; padding: 8px; border-radius: 6px; border: 1px solid #ddd;">
                        <small style="color: #777;">Deixe 0 para itens gratuitos</small>
                    </div>

                    <button type="submit" class="btn" style="width: 100%; background: #4CAF50; color: white;">Adicionar</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
