<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <h2>💳 Configuração de Pagamento (Pix)</h2>
    
    <div class="card">
        <form action="/admin/config/pagamento" method="POST" enctype="multipart/form-data">
            
            <div style="margin-bottom: 20px;">
                <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                    <input type="checkbox" name="is_active" value="1" <?= $pix['is_active'] ? 'checked' : '' ?> style="width: 20px; height: 20px;">
                    <span style="font-weight: bold; font-size: 1.1rem;">Ativar Pagamento via Pix</span>
                </label>
            </div>

            <div style="margin-bottom: 20px;">
                <label for="pix_key_type" style="display: block; margin-bottom: 5px;">Tipo de Chave</label>
                <select name="pix_key_type" id="pix_key_type" class="form-control" style="width: 100%; padding: 10px; border-radius: 6px; border: 1px solid #ddd;" onchange="toggleFields()">
                    <option value="cpf" <?= $pix['pix_key_type'] == 'cpf' ? 'selected' : '' ?>>CPF</option>
                    <option value="email" <?= $pix['pix_key_type'] == 'email' ? 'selected' : '' ?>>E-mail</option>
                    <option value="phone" <?= $pix['pix_key_type'] == 'phone' ? 'selected' : '' ?>>Telefone (Celular)</option>
                    <option value="random" <?= $pix['pix_key_type'] == 'random' ? 'selected' : '' ?>>Chave Aleatória</option>
                    <option value="qr_file" <?= $pix['pix_key_type'] == 'qr_file' ? 'selected' : '' ?>>Apenas Imagem (QR Code)</option>
                </select>
            </div>

            <div id="key_value_group" style="margin-bottom: 20px;">
                <label for="pix_key_value" style="display: block; margin-bottom: 5px;">Chave Pix</label>
                <input type="text" name="pix_key_value" id="pix_key_value" value="<?= htmlspecialchars($pix['pix_key_value']) ?>" 
                    placeholder="Digite a chave Pix aqui" 
                    style="width: 100%; padding: 10px; border-radius: 6px; border: 1px solid #ddd;">
            </div>

            <div style="margin-bottom: 20px; border-top: 1px solid #eee; padding-top: 20px;">
                <label style="display: block; margin-bottom: 10px;">Imagem do QR Code (Opcional ou Principal)</label>
                
                <?php if (!empty($pix['pix_qr_image'])): ?>
                    <div style="margin-bottom: 10px;">
                        <img src="../../<?= $pix['pix_qr_image'] ?>" alt="QR Code Atual" style="max-width: 200px; border: 1px solid #ddd; padding: 5px; border-radius: 6px;">
                        <input type="hidden" name="current_qr_image" value="<?= $pix['pix_qr_image'] ?>">
                        <p style="font-size: 0.8rem; color: #666;">QR Code atual carregado.</p>
                    </div>
                <?php endif; ?>

                <input type="file" name="qr_image" accept="image/*" style="width: 100%;">
                <small style="display: block; margin-top: 5px; color: #666;">Faça upload do QR Code gerado pelo seu banco se desejar.</small>
            </div>

            <button type="submit" class="btn" style="background: #4CAF50; color: white; width: 100%; padding: 12px;">Salvar Configurações</button>
        </form>
    </div>
</div>

<script>
function toggleFields() {
    const type = document.getElementById('pix_key_type').value;
    const keyGroup = document.getElementById('key_value_group');
    
    if (type === 'qr_file') {
        keyGroup.style.display = 'none';
    } else {
        keyGroup.style.display = 'block';
    }
}
// Run on load
toggleFields();
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>
