<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <h2>🍔 Configuração do Cardápio</h2>
    
    <div class="card">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3>Itens Cadastrados</h3>
            <a href="/admin/cardapio/novo" class="btn">Adicionar Novo</a>
        </div>
        
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="background: #f0f0f0;">
                    <th style="padding: 10px;">Imagem</th>
                    <th style="padding: 10px; text-align: left;">Nome</th>
                    <th style="padding: 10px; text-align: left;">Categoria</th>
                    <th style="padding: 10px; text-align: right;">Preço</th>
                    <th style="padding: 10px; text-align: center;">Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($products as $item): ?>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 10px;">
                            <img src="<?= $baseUrl ?>/<?= $item['image_url'] ?>" alt="<?= $item['name'] ?>" style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;">
                        </td>
                        <td style="padding: 10px;"><?= htmlspecialchars($item['name']) ?></td>
                        <td style="padding: 10px;"><?= htmlspecialchars($item['category_name']) ?></td>
                        <td style="padding: 10px; text-align: right;">R$ <?= number_format($item['base_price'], 2, ',', '.') ?></td>
                        <td style="padding: 10px; text-align: center;">
                            <a href="<?= $baseUrl ?>/admin/cardapio/<?= $item['id'] ?>/ingredientes" class="btn" style="padding: 5px 10px; font-size: 0.8rem; background: #607D8B; color: white; margin-right: 4px;">Ingredientes</a>
                            <a href="<?= $baseUrl ?>/admin/cardapio/<?= $item['id'] ?>/adicionais" class="btn" style="padding: 5px 10px; font-size: 0.8rem; background: #FF9800; color: white; margin-right: 4px;">Adicionais</a>
                            <a href="<?= $baseUrl ?>/admin/cardapio/<?= $item['id'] ?>/editar" class="btn" style="padding: 5px 10px; font-size: 0.8rem; background: #2196F3; color: white; margin-right: 4px;">Editar</a>
                            <form action="<?= $baseUrl ?>/admin/cardapio/<?= $item['id'] ?>/excluir" method="POST" style="display: inline-block;" onsubmit="return confirm('Tem certeza que deseja excluir este item?');">
                                <button type="submit" class="btn" style="padding: 5px 10px; font-size: 0.8rem; background: #f44336; color: white;">Excluir</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <?php if (!empty($formMode) && !empty($categories)): ?>
        <div class="card" style="margin-top: 20px;">
            <h3><?= $formMode === 'edit' ? 'Editar Item do Cardápio' : 'Adicionar Novo Item' ?></h3>
            <form action="<?= $formMode === 'edit' && !empty($product) ? $baseUrl . '/admin/cardapio/' . $product['id'] . '/editar' : $baseUrl . '/admin/cardapio/novo' ?>" method="POST" enctype="multipart/form-data" style="margin-top: 10px;">
                <div style="display: flex; flex-wrap: wrap; gap: 20px;">
                    <div style="flex: 1; min-width: 260px;">
                        <div style="margin-bottom: 10px;">
                            <label for="name">Nome do produto</label>
                            <input 
                                type="text" 
                                id="name" 
                                name="name" 
                                value="<?= isset($product['name']) ? htmlspecialchars($product['name']) : '' ?>" 
                                style="width: 100%; padding: 8px; border-radius: 6px; border: 1px solid #ddd;"
                                required
                            >
                        </div>

                        <div style="margin-bottom: 10px;">
                            <label for="category_id">Categoria</label>
                            <select 
                                id="category_id" 
                                name="category_id" 
                                style="width: 100%; padding: 8px; border-radius: 6px; border: 1px solid #ddd;"
                                required
                            >
                                <option value="">Selecione uma categoria</option>
                                <?php foreach ($categories as $cat): ?>
                                    <option 
                                        value="<?= $cat['id'] ?>" 
                                        <?= isset($product['category_id']) && (int) $product['category_id'] === (int) $cat['id'] ? 'selected' : '' ?>
                                    >
                                        <?= htmlspecialchars($cat['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div style="margin-bottom: 10px;">
                            <label for="base_price">Preço base (R$)</label>
                            <input 
                                type="text" 
                                id="base_price" 
                                name="base_price" 
                                value="<?= isset($product['base_price']) ? number_format($product['base_price'], 2, ',', '.') : '' ?>" 
                                style="width: 100%; padding: 8px; border-radius: 6px; border: 1px solid #ddd;"
                                required
                            >
                        </div>

                        <div style="margin-bottom: 10px;">
                            <label for="is_active">
                                <input 
                                    type="checkbox" 
                                    id="is_active" 
                                    name="is_active" 
                                    value="1"
                                    <?= !isset($product['is_active']) || $product['is_active'] ? 'checked' : '' ?>
                                >
                                Ativo no cardápio
                            </label>
                        </div>
                    </div>

                    <div style="flex: 1; min-width: 260px;">
                        <div style="margin-bottom: 10px;">
                            <label for="description">Descrição</label>
                            <textarea 
                                id="description" 
                                name="description" 
                                rows="5" 
                                style="width: 100%; padding: 8px; border-radius: 6px; border: 1px solid #ddd;"
                            ><?= isset($product['description']) ? htmlspecialchars($product['description']) : '' ?></textarea>
                        </div>

                        <div style="margin-bottom: 10px;">
                            <label for="image">Foto do produto</label>
                            <input 
                                type="file" 
                                id="image" 
                                name="image" 
                                accept="image/*"
                                style="width: 100%; padding: 6px 0;"
                            >
                            <?php if (!empty($product['image_url'])): ?>
                                <div style="margin-top: 8px;">
                                    <span style="font-size: 0.85rem; color: #555;">Imagem atual:</span><br>
                                    <img src="../../<?= $product['image_url'] ?>" alt="<?= htmlspecialchars($product['name'] ?? '') ?>" style="width: 80px; height: 80px; object-fit: cover; border-radius: 6px;">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div style="margin-top: 10px; text-align: right;">
                    <a href="/admin/cardapio" class="btn" style="margin-right: 8px; background: #ddd; color: #333;">Cancelar</a>
                    <button type="submit" class="btn" style="background: #4CAF50; color: white;">
                        <?= $formMode === 'edit' ? 'Salvar alterações' : 'Cadastrar produto' ?>
                    </button>
                </div>
            </form>
        </div>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
