<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Login - OSiriCascudo</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #f4f4f4;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
        }
        .login-card {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            width: 320px;
            text-align: center;
        }
        .login-card h1 {
            margin-top: 0;
            margin-bottom: 10px;
        }
        .login-card p {
            margin-top: 0;
            margin-bottom: 20px;
            color: #555;
            font-size: 0.9rem;
        }
        .login-card input {
            width: 100%;
            padding: 10px;
            margin-bottom: 12px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-family: inherit;
        }
        .login-card button {
            width: 100%;
            padding: 10px;
            border-radius: 6px;
            border: none;
            background: #8B4513;
            color: white;
            font-weight: 600;
            cursor: pointer;
        }
        .error {
            color: red;
            margin-bottom: 12px;
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <h1>Login</h1>
        <p>Acesso do proprietário ao painel OSiriCascudo</p>
        <?php if (!empty($error)): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <form method="POST" action="/login">
            <input type="text" name="user" placeholder="Usuário" required>
            <input type="password" name="password" placeholder="Senha" required>
            <button type="submit">Entrar</button>
        </form>
    </div>
</body>
</html>

