<?php 
include __DIR__ . '/../layout/header.php'; 

$role = $_SESSION['user_role'] ?? '';
$perms = $_SESSION['user_permissions'] ?? [];
if (!is_array($perms)) {
    $perms = [];
}
$isAdmin = $role === 'admin';

$hasPerm = function($p) use ($perms, $isAdmin) {
    return $isAdmin || in_array($p, $perms);
};
?>

<div class="container" style="margin-top: 20px;">
    <h2>🦀 Backoffice - Sr. Sirigueijo</h2>
    
    <div style="margin-bottom: 20px; display: flex; flex-wrap: wrap; gap: 10px;">
        <?php if ($hasPerm('stock')): ?>
            <a href="<?= $baseUrl ?>/admin/estoque" class="btn">📦 Gerenciar Estoque</a>
        <?php endif; ?>

        <?php if ($hasPerm('menu')): ?>
            <a href="<?= $baseUrl ?>/admin/cardapio" class="btn" style="background: #FF9800; color: white;">🍔 Gerenciar Cardápio</a>
        <?php endif; ?>

        <?php if ($isAdmin): ?>
            <a href="<?= $baseUrl ?>/admin/config/pagamento" class="btn" style="background: #9C27B0; color: white;">💳 Configurar Pix</a>
            <a href="<?= $baseUrl ?>/admin/usuarios" class="btn" style="background: #607D8B; color: white;">👥 Gerenciar Funcionários</a>
            <a href="<?= $baseUrl ?>/admin/delivery" class="btn" style="background: #3F51B5; color: white;">🛵 Bairros / Taxas</a>
            <a href="<?= $baseUrl ?>/admin/cashback" class="btn" style="background: #4CAF50; color: white;">💸 Cashback</a>
        <?php endif; ?>

        <a href="<?= $baseUrl ?>/cozinha" target="_blank" class="btn" style="background: #28a745; color: white;">🍳 Abrir KDS (Cozinha)</a>
    </div>

    <?php if (!empty($criticalStockCount) && $criticalStockCount > 0 && $hasPerm('stock')): ?>
        <div style="background: #ffebee; border: 1px solid #ffcdd2; color: #b71c1c; padding: 15px; border-radius: 8px; margin-bottom: 20px; display: flex; align-items: center; gap: 10px;">
            <span style="font-size: 1.5rem;">⚠️</span>
            <div>
                <strong>Atenção:</strong> Existem <?= $criticalStockCount ?> itens com estoque crítico!
                <a href="<?= $baseUrl ?>/admin/estoque" style="color: #b71c1c; font-weight: bold; text-decoration: underline;">Verificar agora</a>
            </div>
        </div>
    <?php endif; ?>

    <?php if ($hasPerm('dashboard') || $hasPerm('sales')): ?>
        <div style="display: flex; gap: 20px;">
            <div class="card" style="flex: 1; text-align: center;">
                <h3>Vendas Hoje</h3>
                <p style="font-size: 2.5rem; color: var(--primary); font-weight: 800; margin: 10px 0;">
                    R$ <?= number_format($salesToday, 2, ',', '.') ?>
                </p>
                <?php if ($hasPerm('sales')): ?>
                    <a href="<?= $baseUrl ?>/admin/vendas-dia" style="font-size: 0.9rem; text-decoration: underline;">Ver detalhes</a>
                <?php endif; ?>
            </div>

            <div class="card" style="flex: 1; text-align: center;">
                <h3>Pedidos Hoje</h3>
                <p style="font-size: 2.5rem; color: var(--secondary); font-weight: 800; margin: 10px 0;">
                    <?= $ordersToday ?>
                </p>
            </div>
        </div>
    <?php else: ?>
        <div class="card">
            <p>Bem-vindo ao sistema! Utilize o menu acima para navegar.</p>
        </div>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
