<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="container" style="margin-top: 20px;">
    <h2>💸 Cashback de Clientes</h2>
    
    <div class="card">
        <p>Programa de Fidelidade: 5% de volta em todas as compras.</p>
        
        <table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
            <thead>
                <tr style="background: #f0f0f0;">
                    <th style="padding: 10px; text-align: left;">Cliente</th>
                    <th style="padding: 10px; text-align: left;">Telefone</th>
                    <th style="padding: 10px; text-align: right;">Total Gasto</th>
                    <th style="padding: 10px; text-align: right; color: green;">Cashback Disponível</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($customers as $customer): ?>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 10px;"><?= htmlspecialchars($customer['name'] ?? 'Não identificado') ?></td>
                        <td style="padding: 10px;"><?= htmlspecialchars($customer['customer_phone']) ?></td>
                        <td style="padding: 10px; text-align: right;">R$ <?= number_format($customer['total_spent'], 2, ',', '.') ?></td>
                        <td style="padding: 10px; text-align: right; color: green; font-weight: bold;">R$ <?= number_format($customer['potential_cashback'], 2, ',', '.') ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
