<?php

session_start();

require_once __DIR__ . '/../app/autoload.php';

use App\Core\Router;
use App\Controllers\MenuController;
use App\Controllers\CartController;
use App\Controllers\CheckoutController;
use App\Controllers\OrderTrackingController;
use App\Controllers\KitchenController;
use App\Controllers\AdminController;
use App\Controllers\AuthController;
use App\Controllers\AdminTicketsController;
use App\Controllers\AdminSalesController;
use App\Controllers\AdminMenuController;
use App\Controllers\AdminCashbackController;
use App\Controllers\AdminUsersController;
use App\Controllers\AdminDeliveryController;

$router = new Router();

// Cliente
$router->get('/', [MenuController::class, 'index']);
$router->get('/produto/{slug}', [MenuController::class, 'show']);

// Carrinho
$router->get('/carrinho', [CartController::class, 'index']);
$router->post('/carrinho/add', [CartController::class, 'add']);
$router->post('/carrinho/update', [CartController::class, 'update']);
$router->get('/carrinho/remove/{index}', [CartController::class, 'remove']);

// Checkout
$router->get('/checkout', [CheckoutController::class, 'index']);
$router->post('/checkout/process', [CheckoutController::class, 'process']);
$router->post('/checkout/preferences', [CheckoutController::class, 'savePreferences']);
$router->get('/pedido/sucesso/{code}', [CheckoutController::class, 'success']);
$router->get('/rastreio/{code}', [OrderTrackingController::class, 'track']);

// Cozinha / KDS
$router->get('/cozinha', [KitchenController::class, 'index']);
$router->get('/api/cozinha/pedidos', [KitchenController::class, 'getOrders']); // AJAX
$router->post('/api/cozinha/status', [KitchenController::class, 'updateStatus']); // AJAX
$router->get('/api/cozinha/produtos', [KitchenController::class, 'getProducts']); // AJAX POS
$router->post('/api/cozinha/pedido', [KitchenController::class, 'createPosOrder']); // AJAX POS

// Admin
$router->get('/admin', [AdminController::class, 'dashboard']);
$router->get('/admin/estoque', [AdminController::class, 'stock']);
$router->post('/admin/estoque/critico', [AdminController::class, 'updateStockCritical']);
$router->post('/admin/estoque/adicionar', [AdminController::class, 'addIngredient']);
$router->post('/admin/estoque/{id}/excluir', [AdminController::class, 'deleteIngredient']);
$router->get('/admin/estoque/imprimir', [AdminController::class, 'printShoppingList']);

$router->get('/admin/config/pagamento', [AdminController::class, 'editPayments']);
$router->post('/admin/config/pagamento', [AdminController::class, 'updatePayments']);
$router->get('/admin/cardapio', [AdminMenuController::class, 'index']);
$router->get('/admin/cardapio/novo', [AdminMenuController::class, 'create']);
$router->post('/admin/cardapio/novo', [AdminMenuController::class, 'store']);
$router->get('/admin/cardapio/{id}/editar', [AdminMenuController::class, 'edit']);
$router->post('/admin/cardapio/{id}/editar', [AdminMenuController::class, 'update']);
$router->post('/admin/cardapio/{id}/excluir', [AdminMenuController::class, 'delete']);
$router->get('/admin/cardapio/{id}/adicionais', [AdminMenuController::class, 'options']);
$router->post('/admin/cardapio/{id}/adicionais', [AdminMenuController::class, 'optionsStore']);
$router->post('/admin/cardapio/{id}/adicionais/{optId}/excluir', [AdminMenuController::class, 'optionsDelete']);
$router->get('/admin/cardapio/{id}/ingredientes', [AdminMenuController::class, 'ingredients']);
$router->post('/admin/cardapio/{id}/ingredientes', [AdminMenuController::class, 'ingredientsStore']);
$router->post('/admin/cardapio/{id}/ingredientes/{ingId}/excluir', [AdminMenuController::class, 'ingredientsDelete']);

// Usuários
$router->get('/admin/usuarios', [AdminUsersController::class, 'index']);
$router->get('/admin/usuarios/novo', [AdminUsersController::class, 'create']);
$router->post('/admin/usuarios/novo', [AdminUsersController::class, 'store']);
$router->get('/admin/usuarios/{id}/editar', [AdminUsersController::class, 'edit']);
$router->post('/admin/usuarios/{id}/editar', [AdminUsersController::class, 'update']);
$router->post('/admin/usuarios/{id}/excluir', [AdminUsersController::class, 'delete']);

// Entrega
$router->get('/admin/delivery', [AdminDeliveryController::class, 'index']);
$router->post('/admin/delivery/save', [AdminDeliveryController::class, 'save']);
$router->post('/admin/delivery/{id}/delete', [AdminDeliveryController::class, 'delete']);

// Relatórios / Utilidades Admin
$router->get('/admin/tickets', [AdminTicketsController::class, 'index']);
$router->get('/admin/vendas-dia', [AdminSalesController::class, 'daily']);
$router->get('/admin/cashback', [AdminCashbackController::class, 'index']);

// Autenticação Admin
$router->get('/login', [AuthController::class, 'showLogin']);
$router->post('/login', [AuthController::class, 'login']);
$router->get('/logout', [AuthController::class, 'logout']);

// Dispatch
$uri = $_SERVER['REQUEST_URI'];
$method = $_SERVER['REQUEST_METHOD'];

// Gambiarra para rodar em subpasta se nao tiver vhost
$scriptName = dirname($_SERVER['SCRIPT_NAME']);
if ($scriptName !== '/' && strpos($uri, $scriptName) === 0) {
    $uri = substr($uri, strlen($scriptName));
}

$router->dispatch($uri, $method);
