<?php
require_once __DIR__ . '/app/autoload.php';

use App\Core\Database;

$db = Database::getInstance()->getConnection();

echo "Fixing image paths...\n";

$products = $db->query("SELECT id, image_url FROM products WHERE image_url LIKE 'public/%'")->fetchAll();

foreach ($products as $p) {
    $newPath = substr($p['image_url'], 7); // Remove 'public/'
    $stmt = $db->prepare("UPDATE products SET image_url = ? WHERE id = ?");
    $stmt->execute([$newPath, $p['id']]);
    echo "Updated product {$p['id']}: {$p['image_url']} -> {$newPath}\n";
}

echo "Done.\n";
