<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\Database;

class AdminCashbackController extends Controller
{
    public function index()
    {
        $this->checkPermission();
        $db = Database::getInstance()->getConnection();
        
        // Simulate cashback calculation based on phone number history
        // Assuming 5% cashback
        $stmt = $db->query("
            SELECT 
                customer_phone, 
                MAX(customer_name) as name, 
                SUM(total_amount) as total_spent, 
                SUM(total_amount) * 0.05 as potential_cashback 
            FROM orders 
            WHERE customer_phone IS NOT NULL AND customer_phone != '' 
            GROUP BY customer_phone 
            ORDER BY total_spent DESC
        ");
        $customers = $stmt->fetchAll();

        $this->view('admin.cashback', ['customers' => $customers]);
    }
}
